/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SingleSelectionDialog
extends Dialog
implements ISelectionChangedListener {
    private static final int LIST_HEIGHT = 300;
    private static final int LIST_WIDTH = 300;
    private TableViewer list;
    private Button okButton;
    private Object input;
    private IStructuredContentProvider contentProvider;
    private ILabelProvider labelProvider;
    private Object selection;
    private String title;

    public SingleSelectionDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, Object selection, String title) {
        super(parentShell);
        this.input = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        this.selection = selection;
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateButtons();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createViewer(composite);
        this.layoutTopControl(this.list.getControl());
        return composite;
    }

    private void createViewer(Composite parent) {
        this.list = new TableViewer(parent, 2820);
        this.list.getTable().setFont(parent.getFont());
        this.list.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.list.setContentProvider((IContentProvider)this.contentProvider);
        this.list.setSorter(new ViewerSorter());
        this.list.setInput(this.input);
        this.list.addSelectionChangedListener((ISelectionChangedListener)this);
        this.list.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SingleSelectionDialog.this.handleDoubleClickEvent();
            }
        });
    }

    public Object getSelection() {
        return this.selection;
    }

    protected void handleDoubleClickEvent() {
        this.okPressed();
    }

    private void layoutTopControl(Control control) {
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        control.setLayoutData((Object)spec);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.okButton.setEnabled(this.getSelection() != null);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        this.selection = null;
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (!sel.isEmpty()) {
            this.selection = sel.getFirstElement();
        }
    }
}

