/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IBuffer;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IOpenable;
import org.asnlab.asndt.core.WorkingCopyOwner;
import org.asnlab.asndt.internal.core.AsnModelManager;
import org.asnlab.asndt.internal.corext.template.asn.AsnContextType;
import org.asnlab.asndt.internal.corext.template.asn.CodeTemplateContextType;
import org.asnlab.asndt.internal.corext.template.asn.CodeTemplates;
import org.asnlab.asndt.internal.corext.template.asn.Templates;
import org.asnlab.asndt.internal.corext.util.QualifiedTypeNameHistory;
import org.asnlab.asndt.internal.ui.AsnPluginImages;
import org.asnlab.asndt.internal.ui.AsnUIMessages;
import org.asnlab.asndt.internal.ui.CompatibilityTemplateStore;
import org.asnlab.asndt.internal.ui.InitializeAfterLoadJob;
import org.asnlab.asndt.internal.ui.asneditor.ASTProvider;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitDocumentProvider;
import org.asnlab.asndt.internal.ui.asneditor.DocumentAdapter;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.asneditor.ICompilationUnitDocumentProvider;
import org.asnlab.asndt.internal.ui.asneditor.WorkingCopyManager;
import org.asnlab.asndt.internal.ui.text.PreferencesAdapter;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverDescriptor;
import org.asnlab.asndt.internal.ui.text.folding.AsnFoldingStructureProviderRegistry;
import org.asnlab.asndt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.asnlab.asndt.internal.ui.viewsupport.ProblemMarkerManager;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class AsnPlugin
extends AbstractUIPlugin {
    private static final String TEMPLATES_KEY = "org.asnlab.asndt.ui.text.custom_templates";
    private static final String CODE_TEMPLATES_KEY = "org.asnlab.asndt.ui.text.custom_code_templates";
    private static final String TEMPLATES_MIGRATION_KEY = "org.asnlab.asndt.ui.text.templates_migrated";
    private static final String CODE_TEMPLATES_MIGRATION_KEY = "org.asnlab.asndt.ui.text.code_templates_migrated";
    private static AsnPlugin fgAsnPlugin;
    private static LinkedHashMap fgRepeatedMessages;
    private ContextTypeRegistry fContextTypeRegistry;
    private ContextTypeRegistry fCodeTemplateContextTypeRegistry;
    private TemplateStore fTemplateStore;
    private TemplateStore fCodeTemplateStore;
    private WorkingCopyManager fWorkingCopyManager;
    private ICompilationUnitDocumentProvider fCompilationUnitDocumentProvider;
    private AsnTextTools fAsnTextTools;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private IPropertyChangeListener fFontPropertyChangeListener;
    private AsnEditorTextHoverDescriptor[] fAsnEditorTextHoverDescriptors;
    private ASTProvider fASTProvider;
    private IPreferenceStore fCombinedPreferenceStore;
    private AsnFoldingStructureProviderRegistry fFoldingStructureProviderRegistry;

    static {
        fgRepeatedMessages = new LinkedHashMap(20, 0.75f, true){
            private static final long serialVersionUID = 1L;

            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() >= 20;
            }
        };
    }

    public static AsnPlugin getDefault() {
        return fgAsnPlugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchPage getActivePage() {
        return AsnPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return AsnPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = AsnPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        return EditorUtility.getDirtyEditors();
    }

    public static String getPluginId() {
        return "org.asnlab.asndt.ui";
    }

    public static void log(IStatus status) {
        AsnPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        AsnPlugin.log((IStatus)new Status(4, AsnPlugin.getPluginId(), 10001, message, null));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            AsnPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(AsnPlugin.getPluginId(), 10001, message, null);
        multi.add(status);
        AsnPlugin.log((IStatus)multi);
    }

    public static void log(Throwable e) {
        AsnPlugin.log((IStatus)new Status(4, AsnPlugin.getPluginId(), 10001, AsnUIMessages.AsnPlugin_internal_error, e));
    }

    public static void logRepeatedMessage(String message, String detail) {
        long now = System.currentTimeMillis();
        boolean writeToLog = true;
        if (fgRepeatedMessages.containsKey(message)) {
            long last = (Long)fgRepeatedMessages.get(message);
            writeToLog = now - last > 5000L;
        }
        fgRepeatedMessages.put(message, new Long(now));
        if (writeToLog) {
            AsnPlugin.log(new Exception(String.valueOf(message) + detail).fillInStackTrace());
        }
    }

    public static boolean isDebug() {
        return AsnPlugin.getDefault().isDebugging();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return AsnPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    public AsnPlugin() {
        fgAsnPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource instanceof IFile) {
                    return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                }
                return DocumentAdapter.NULL;
            }
        });
        this.ensurePreferenceStoreBackwardsCompatibility();
        this.getASTProvider();
        new InitializeAfterLoadJob().schedule();
    }

    static void initializeAfterLoad(IProgressMonitor monitor) {
        try {
            AsnModelManager.getAsnModelManager().getAsnModel().open(monitor);
        }
        catch (AsnModelException e) {
            AsnPlugin.log(e);
        }
    }

    private static IPreferenceStore getDeprecatedWorkbenchPreferenceStore() {
        return PlatformUI.getWorkbench().getPreferenceStore();
    }

    private void ensurePreferenceStoreBackwardsCompatibility() {
        IPreferenceStore store = this.getPreferenceStore();
        String fontPropagatedKey = "fontPropagated";
        if (store.contains("org.eclipse.jface.textfont") && !store.isDefault("org.eclipse.jface.textfont") && !store.getBoolean(fontPropagatedKey)) {
            PreferenceConverter.setValue((IPreferenceStore)AsnPlugin.getDeprecatedWorkbenchPreferenceStore(), (String)"org.asnlab.asndt.ui.editors.textfont", (FontData[])PreferenceConverter.getFontDataArray((IPreferenceStore)store, (String)"org.eclipse.jface.textfont"));
        }
        store.setValue(fontPropagatedKey, true);
        PreferenceConverter.putValue((IPreferenceStore)store, (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.asnlab.asndt.ui.editors.textfont"));
        this.fFontPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.asnlab.asndt.ui.editors.textfont".equals(event.getProperty())) {
                    PreferenceConverter.putValue((IPreferenceStore)AsnPlugin.this.getPreferenceStore(), (String)"org.eclipse.jface.textfont", (FontData[])JFaceResources.getFontRegistry().getFontData("org.asnlab.asndt.ui.editors.textfont"));
                }
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        String proposalOrderMigrated = "proposalOrderMigrated";
        store.setValue(proposalOrderMigrated, true);
    }

    private void uninstallPreferenceStoreBackwardsCompatibility() {
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
    }

    protected ImageRegistry createImageRegistry() {
        return AsnPluginImages.getImageRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.fImageDescriptorRegistry != null) {
                this.fImageDescriptorRegistry.dispose();
            }
            if (this.fASTProvider != null) {
                this.fASTProvider.dispose();
                this.fASTProvider = null;
            }
            if (this.fWorkingCopyManager != null) {
                this.fWorkingCopyManager.shutdown();
                this.fWorkingCopyManager = null;
            }
            if (this.fCompilationUnitDocumentProvider != null) {
                this.fCompilationUnitDocumentProvider.shutdown();
                this.fCompilationUnitDocumentProvider = null;
            }
            if (this.fAsnTextTools != null) {
                this.fAsnTextTools.dispose();
                this.fAsnTextTools = null;
            }
            this.uninstallPreferenceStoreBackwardsCompatibility();
            if (this.fTemplateStore != null) {
                this.fTemplateStore.stopListeningForPreferenceChanges();
                this.fTemplateStore = null;
            }
            if (this.fCodeTemplateStore != null) {
                this.fCodeTemplateStore.stopListeningForPreferenceChanges();
                this.fCodeTemplateStore = null;
            }
            QualifiedTypeNameHistory.getDefault().save();
            AsnModelManager.getAsnModelManager().getAsnModel().close();
        }
        finally {
            super.stop(context);
        }
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    public synchronized ICompilationUnitDocumentProvider getCompilationUnitDocumentProvider() {
        if (this.fCompilationUnitDocumentProvider == null) {
            this.fCompilationUnitDocumentProvider = new CompilationUnitDocumentProvider();
        }
        return this.fCompilationUnitDocumentProvider;
    }

    public synchronized WorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ICompilationUnitDocumentProvider provider = this.getCompilationUnitDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public synchronized AsnTextTools getAsnTextTools() {
        if (this.fAsnTextTools == null) {
            this.fAsnTextTools = new AsnTextTools(this.getPreferenceStore(), AsnCore.getPlugin().getPluginPreferences());
        }
        return this.fAsnTextTools;
    }

    public synchronized ASTProvider getASTProvider() {
        if (this.fASTProvider == null) {
            this.fASTProvider = new ASTProvider();
        }
        return this.fASTProvider;
    }

    public AsnEditorTextHoverDescriptor[] getAsnEditorTextHoverDescriptors() {
        if (this.fAsnEditorTextHoverDescriptors == null) {
            this.fAsnEditorTextHoverDescriptors = AsnEditorTextHoverDescriptor.getContributedHovers();
            ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

                public IConfigurationElement getConfigurationElement(Object object) {
                    return ((AsnEditorTextHoverDescriptor)object).getConfigurationElement();
                }
            };
            sorter.sort((Object[])this.fAsnEditorTextHoverDescriptors);
            int i = 0;
            while (i < this.fAsnEditorTextHoverDescriptors.length - 1) {
                if ("org.asnlab.asndt.ui.BestMatchHover".equals(this.fAsnEditorTextHoverDescriptors[i].getId())) {
                    AsnEditorTextHoverDescriptor hoverDescriptor = this.fAsnEditorTextHoverDescriptors[i];
                    int j = i;
                    while (j > 0) {
                        this.fAsnEditorTextHoverDescriptors[j] = this.fAsnEditorTextHoverDescriptors[j - 1];
                        --j;
                    }
                    this.fAsnEditorTextHoverDescriptors[0] = hoverDescriptor;
                    break;
                }
                ++i;
            }
        }
        return this.fAsnEditorTextHoverDescriptors;
    }

    public void resetAsnEditorTextHoverDescriptors() {
        this.fAsnEditorTextHoverDescriptors = null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            this.fContextTypeRegistry = new ContributionContextTypeRegistry();
            this.fContextTypeRegistry.addContextType((TemplateContextType)new AsnContextType());
        }
        return this.fContextTypeRegistry;
    }

    public TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean alreadyMigrated = store.getBoolean(TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), store, TEMPLATES_KEY);
            } else {
                this.fTemplateStore = new CompatibilityTemplateStore(this.getTemplateContextRegistry(), store, TEMPLATES_KEY, this.getOldTemplateStoreInstance());
                store.setValue(TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                AsnPlugin.log(e);
            }
            this.fTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fTemplateStore;
    }

    private Templates getOldTemplateStoreInstance() {
        return Templates.getInstance();
    }

    public ContextTypeRegistry getCodeTemplateContextRegistry() {
        if (this.fCodeTemplateContextTypeRegistry == null) {
            this.fCodeTemplateContextTypeRegistry = new ContributionContextTypeRegistry();
            CodeTemplateContextType.registerContextTypes(this.fCodeTemplateContextTypeRegistry);
        }
        return this.fCodeTemplateContextTypeRegistry;
    }

    public TemplateStore getCodeTemplateStore() {
        if (this.fCodeTemplateStore == null) {
            IPreferenceStore store = this.getPreferenceStore();
            boolean alreadyMigrated = store.getBoolean(CODE_TEMPLATES_MIGRATION_KEY);
            if (alreadyMigrated) {
                this.fCodeTemplateStore = new ContributionTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY);
            } else {
                this.fCodeTemplateStore = new CompatibilityTemplateStore(this.getCodeTemplateContextRegistry(), store, CODE_TEMPLATES_KEY, this.getOldCodeTemplateStoreInstance());
                store.setValue(CODE_TEMPLATES_MIGRATION_KEY, true);
            }
            try {
                this.fCodeTemplateStore.load();
            }
            catch (IOException e) {
                AsnPlugin.log(e);
            }
            this.fCodeTemplateStore.startListeningForPreferenceChanges();
            CompatibilityTemplateStore.pruneDuplicates(this.fCodeTemplateStore, true);
        }
        return this.fCodeTemplateStore;
    }

    private CodeTemplates getOldCodeTemplateStoreInstance() {
        return CodeTemplates.getInstance();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public IPreferenceStore getCombinedPreferenceStore() {
        if (this.fCombinedPreferenceStore == null) {
            IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
            this.fCombinedPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), new PreferencesAdapter(AsnCore.getPlugin().getPluginPreferences()), generalTextStore});
        }
        return this.fCombinedPreferenceStore;
    }

    public synchronized AsnFoldingStructureProviderRegistry getFoldingStructureProviderRegistry() {
        if (this.fFoldingStructureProviderRegistry == null) {
            this.fFoldingStructureProviderRegistry = new AsnFoldingStructureProviderRegistry();
        }
        return this.fFoldingStructureProviderRegistry;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }
}

